<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->unsignedInteger('vehicle_length')->nullable()->index();
        });

        Schema::table('body_styles', function (Blueprint $table) {
            $table->boolean('has_subcategories')->nullable()->index();
            $table->integer('small_if_under')->nullable();
            $table->integer('large_if_above')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicles', function (Blueprint $table) {
            $table->dropColumn('vehicle_length');
        });

        Schema::table('body_styles', function (Blueprint $table) {
            $table->dropColumn([
                'has_subcategories',
                'small_if_under',
                'large_if_above',
            ]);
        });
    }
};
