<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('new_car_finance', function (Blueprint $table) {
            $table->id();
            $table->foreignId('new_car_id')->index();
            $table->string('provider')->nullable()->index();
            $table->string('finance_type', 5)->nullable()->index();
            $table->decimal('first_payment')->nullable();
            $table->decimal('monthly_price')->nullable()->index();
            $table->decimal('final_payment')->nullable();
            $table->decimal('full_price')->nullable();
            $table->decimal('customer_deposit')->nullable();
            $table->decimal('dealer_deposit_contribution')->nullable();
            $table->decimal('deposit')->nullable();
            $table->decimal('total_amount')->nullable();
            $table->decimal('total_credit_amount')->nullable();
            $table->decimal('apr', 5)->nullable();
            $table->decimal('interest_rate', 5)->nullable();
            $table->smallInteger('number_of_payments')->nullable();
            $table->text('data')->nullable();
            $table->smallInteger('term')->nullable();
            $table->integer('annual_mileage')->nullable();
            $table->decimal('option_to_purchase_fee')->nullable();
            $table->decimal('excess_mileage_charge')->nullable();
            $table->decimal('documentation_fee')->nullable();
            $table->decimal('payable_amount')->nullable();
            $table->timestamps();
        });

        Schema::table('vehicle_offer_finance', function (Blueprint $table) {
            $table->decimal('documentation_fee')->nullable();
            $table->decimal('payable_amount')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('new_car_finance');

        Schema::table('vehicle_offer_finance', function (Blueprint $table) {
            $table->dropColumn(['documentation_fee', 'payable_amount']);
        });
    }
};
