<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\MercuryDataModels\Factories\CarConfiguratorInteriorFactory;

class CarConfiguratorInterior extends Model
{
    use HasFactory;
    use SoftDeletes;
    use HasMedia;

    protected $table = 'car_configurator_interiors';

    protected $fillable = [
        'model_id',
        'name',
        'description',
        'category',
        'price',
        'hex',
        'hex_gradient',
        'order',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function newFactory()
    {
        return CarConfiguratorInteriorFactory::new();
    }

    public function restrictions(): MorphMany
    {
        return $this->morphMany(CarConfiguratorRestriction::class, 'functionality');
    }
}
