<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\MercuryDataModels\Factories\CarConfiguratorTrimFactory;

class CarConfiguratorTrim extends Model
{
    use HasFactory;
    use HasMedia;
    use SoftDeletes;

    protected $table = 'car_configurator_trims';

    protected $fillable = [
        'model_id',
        'name',
        'short_description',
        'description',
        'price',
        'monthly_price',
        'data',
        'fuel_type_id',
        'order',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    protected static function newFactory()
    {
        return CarConfiguratorTrimFactory::new();
    }

    public function model(): BelongsTo
    {
        return $this->belongsTo(CarConfiguratorModel::class, 'model_id');
    }

    public function fuelType(): BelongsTo
    {
        return $this->belongsTo(FuelType::class);
    }

    public function restrictions(): MorphMany
    {
        return $this->morphMany(CarConfiguratorRestriction::class, 'functionality');
    }
}
