<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (Schema::hasColumn('vehicle_makes', 'keyloop_id') === false) {
            Schema::table('vehicle_makes', function (Blueprint $table) {
                $table->string('keyloop_id')->nullable()->index();
            });
        }

        if (Schema::hasColumn('vehicle_models', 'keyloop_id') === false) {
            Schema::table('vehicle_models', function (Blueprint $table) {
                $table->string('keyloop_id')->nullable()->index();
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('vehicle_makes', 'keyloop_id')) {
            Schema::table('vehicle_makes', function (Blueprint $table) {
                $table->dropColumn('keyloop_id');
            });
        }

        if (Schema::hasColumn('vehicle_models', 'keyloop_id')) {
            Schema::table('vehicle_models', function (Blueprint $table) {
                $table->dropColumn('keyloop_id');
            });
        }
    }
};
