<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::table('vehicle_attributes', function (Blueprint $table) {
            $table->string('model')->after('id')->nullable();
        });

        DB::table('vehicle_attributes')
            ->whereNull('model')
            ->update(['model' => 'vehicle']);

        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->renameColumn('vehicle_id', 'owner_id');
        });

        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->string('owner_type')->nullable()->after('owner_id');

            $table->index(['owner_id', 'owner_type']);
        });

        DB::table('vehicle_attribute_values')
            ->whereNotNull('owner_id')
            ->update(['owner_type' => 'vehicle']);
    }

    /**
     * Reverse the migrations.
     */
    public function down()
    {
        Schema::table('vehicle_attributes', function (Blueprint $table) {
            $table->dropColumn('model');
        });

        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->dropColumn('owner_type');

            $table->renameColumn('owner_id', 'vehicle_id');

            $table->dropIndex(['owner_id', 'owner_type']);
        });
    }
};
