<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\Factories\CarConfigurationFactory;

class CustomerCarConfiguration extends Model
{
    use HasFactory;

    protected $table = 'customer_car_configurations';

    protected $fillable = [
        'uuid',
        'email',
        'phone_number',
        'name',
        'customer_id',
        'enquiry_id',
        'model_id',
        'views',
    ];

    protected static function newFactory()
    {
        return CarConfigurationFactory::new();
    }

    public function model(): BelongsTo
    {
        return $this->belongsTo(CarConfiguratorModel::class);
    }

    public function customer(): BelongsTo
    {
        return $this->belongsTo(Customer::class);
    }

    public function enquiry(): BelongsTo
    {
        return $this->belongsTo(Enquiry::class);
    }

    public function sections(): HasMany
    {
        return $this->hasMany(CustomerCarConfigurationSection::class, 'configuration_id');
    }

    public function loadEnquiryRelations(): void
    {
        $this->load([
            'model.make',
            'model.model',
            'sections.section'
        ]);
    }
}
