<?php

namespace Mtc\MercuryDataModels;

use Carbon\Carbon;
use Mtc\MercuryDataModels\Factories\TenantBillableFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\SoftDeletes;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class TenantBillable extends Model
{
    use HasFactory;
    use CentralConnection;
    use SoftDeletes;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'tenant_billables';

    /**
     * Mass assign attributes
     *
     * @var array
     */
    protected $fillable = [
        'tenant_id',
        'billable_id',
        'price',
        'discounted_price',
        'quantity',
        'notes',
        'billed_from',
        'billed_until',
    ];

    /**
     * Model Factory
     *
     * @return TenantBillableFactory
     */
    protected static function newFactory()
    {
        return TenantBillableFactory::new();
    }

    /**
     * Relationship with tenant
     *
     * @return BelongsTo
     */
    public function tenant(): BelongsTo
    {
        return $this->belongsTo(Tenant::class);
    }

    /**
     * Relationship with billable data object
     *
     * @return BelongsTo
     */
    public function billable(): BelongsTo
    {
        return $this->belongsTo(Billable::class);
    }

    /**
     * Check if this billable is applicable for this period
     * Might be a future or expiring billable
     *
     * @return bool
     */
    public function isApplicableNow(): bool
    {
        return ($this->attributes['billed_from'] === null || $this->attributes['billed_from'] <= Carbon::now())
            || ($this->attributes['billed_to'] === null || $this->attributes['billed_to'] >= Carbon::now());
    }
}
