<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class CustomerCarConfigurationSection extends Model
{
    protected $table = 'customer_car_configuration_sections';

    protected $fillable = [
        'configuration_id',
        'section_id',
        'details',
    ];

    protected $casts = [
        'details' => 'array',
    ];

    public function configuration(): BelongsTo
    {
        return $this->belongsTo(CustomerCarConfiguration::class);
    }

    public function section(): BelongsTo
    {
        return $this->belongsTo(CarConfiguratorSection::class);
    }
}
