<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\SalesChannelHistory;

class SalesChannelHistoryFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = SalesChannelHistory::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'channel' => $this->faker->word(),
            'vehicle_id' => $this->faker->boolean() ? null : random_int(1, 1000),
            'was_successful' => $this->faker->boolean(),
            'details' => $this->faker->sentence(),
        ];
    }
}
