<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_usage', function (Blueprint $table) {
            $table->id();
            $table->string('tenant_id')->index()->nullable();
            $table->string('endpoint')->index();
            $table->string('method')->nullable()->index();
            $table->dateTime('time_window')->nullable()->index();
            $table->unsignedInteger('hits')->nullable()->index();
            $table->decimal('avg')->nullable()->index();
            $table->decimal('min')->nullable()->index();
            $table->decimal('max')->nullable()->index();
            $table->timestamps();
        });

        Schema::create('api_usage_snapshots', function (Blueprint $table) {
            $table->id();
            $table->foreignId('api_usage_id')->index();
            $table->text('input')->nullable();
            $table->decimal('request_time')->nullable()->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_usage');
        Schema::dropIfExists('api_usage_snapshots');
    }
};
