<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVehicleTables extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicles', function (Blueprint $table) {
            $table->id();
            $table->string('slug')->nullable()->index();
            $table->string('uuid')->index()->nullable();
            $table->string('auto_trader_id')->index()->nullable();
            $table->string('cap_id')->index()->nullable();
            $table->string('vin')->index()->nullable();
            $table->string('type')->index()->nullable();
            $table->dateTime('published_at')->nullable();
            $table->string('title')->index()->nullable();
            $table->string('derivative')->index()->nullable();
            $table->string('registration_number')->index()->nullable();
            $table->boolean('personalized_number_plate')->nullable();
            $table->boolean('is_new')->index()->nullable();
            $table->boolean('featured')->index()->default(0);
            $table->unsignedBigInteger('make_id')->index()->nullable();
            $table->unsignedBigInteger('model_id')->index()->nullable();
            $table->unsignedBigInteger('transmission_id')->index()->nullable();
            $table->unsignedBigInteger('fuel_type_id')->index()->nullable();
            $table->unsignedBigInteger('body_style_id')->index()->nullable();
            $table->unsignedBigInteger('drivetrain_id')->index()->nullable();
            $table->unsignedBigInteger('dealership_id')->index()->nullable();
            $table->string('colour')->nullable()->index();

            $table->decimal('price')->index()->nullable();
            $table->decimal('monthly_price')->index()->nullable();
            $table->decimal('deposit')->index()->nullable();

            $table->unsignedSmallInteger('door_count')->nullable()->index();
            $table->unsignedSmallInteger('seats')->nullable()->index();
            $table->unsignedSmallInteger('manufacture_year')->nullable()->index();
            $table->unsignedInteger('odometer_km')->nullable()->index();
            $table->unsignedInteger('odometer_mi')->nullable()->index();
            $table->unsignedInteger('engine_size_cc')->nullable()->index();
            $table->unsignedInteger('co2')->nullable()->index();
            $table->decimal('mpg')->nullable()->index();

            $table->unsignedSmallInteger('previous_owner_count')->nullable();
            $table->date('first_registration_date')->nullable();
            $table->text('description')->nullable();
            $table->longText('data')->nullable();
            $table->string('exterior_video_url')->nullable();
            $table->string('interior_video_url')->nullable();

            $table->text('search_content')->nullable();
            if (app()->runningUnitTests() === false) {
                $table->fullText('search_content');
            }

            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('vehicle_standard_equipment', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('vehicle_id')->index();

            $table->string('type')->nullable()->index()->comment('type of data: standard equipment, optional equipment');
            $table->string('code')->nullable()->index();
            $table->string('description')->nullable();
            $table->string('category')->nullable()->index();
            $table->decimal('price', 8, 2)->nullable();
            $table->decimal('vat_amount', 8, 2)->nullable();

            $table->timestamps();
        });

        Schema::create('vehicle_finance', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('vehicle_id')->index();
            $table->string('provider');
            $table->string('finance_type');

            $table->smallInteger('term')->comment('term length in months');
            $table->smallInteger('number_of_payments')->comment('number of monthly payments');

            $table->decimal('monthly_price');
            $table->decimal('first_payment');
            $table->decimal('final_payment');

            $table->decimal('deposit');
            $table->decimal('interest_rate');
            $table->decimal('apr');

            $table->string('apply_url')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicles');
        Schema::dropIfExists('vehicle_standard_equipment');
        Schema::dropIfExists('vehicle_finance');
    }
}
