<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->unique([
                'vehicle_id',
                'attribute_id',
                'index',
            ], 'unique_vehicle_attribute_value');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_attribute_values', function (Blueprint $table) {
            $table->dropIndex('unique_vehicle_attribute_value');
        });
    }
};
