<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\MercuryDataModels\Factories\CarConfiguratorEngineFactory;

class CarConfiguratorEngine extends Model
{
    use HasFactory;
    use HasMedia;
    use SoftDeletes;

    protected $table = 'car_configurator_engines';

    protected $fillable = [
        'model_id',
        'name',
        'description',
        'short_description',
        'price',
        'fuel_type_id',
        'drivetrain_id',
        'transmission_id',
        'fuel_consumption_combined',
        'bhp',
        'max_ev_power',
        'max_engine_power',
        'torque',
        'zero_to_sixty',
        'fuel_capacity',
        'ev_range',
        'order',
        'data',
    ];

    protected $casts = [
        'data' => 'json'
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function newFactory()
    {
        return CarConfiguratorEngineFactory::new();
    }

    public function restrictions(): MorphMany
    {
        return $this->morphMany(CarConfiguratorRestriction::class, 'functionality');
    }

    public function drivetrain(): BelongsTo
    {
        return $this->belongsTo(DrivetrainType::class, 'drivetrain_id');
    }

    public function fuelType(): BelongsTo
    {
        return $this->belongsTo(FuelType::class, 'fuel_type_id');
    }

    public function transmission(): BelongsTo
    {
        return $this->belongsTo(TransmissionType::class, 'transmission_id');
    }
}
