<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('content_elements', function (Blueprint $table) {
            $table->string('ui_component')->nullable()->after('category');
        });
        Schema::table('global_content', function (Blueprint $table) {
            $table->string('ui_component')->nullable()->after('type');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('content_elements', function (Blueprint $table) {
            $table->dropColumn('ui_component');
        });
        Schema::table('global_content', function (Blueprint $table) {
            $table->dropColumn('ui_component');
        });
    }
};
