<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\CarConfiguratorCustomSection;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\ColourMap>
 */
class CarConfiguratorCustomSectionFactory extends Factory
{
    protected $model = CarConfiguratorCustomSection::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'model_id' => random_int(1, 1000),
            'section_id' => random_int(1, 1000),
            'name' => $this->faker->word(),
            'description' => $this->faker->sentence(),
            'price' => random_int(1, 1000),
            'hex' => $this->faker->hexColor(),
            'hex_gradient' => $this->faker->hexColor(),
        ];
    }
}
