<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('release_notes', function (Blueprint $table) {
            $table->id();
            $table->boolean('is_published')->index();
            $table->dateTime('published_at')->nullable()->index();
            $table->string('title');
            $table->text('content')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
        });

        Schema::table('users', function (Blueprint $table) {
            $table->dateTime('release_notes_checked_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('release_notes');

        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn('release_notes_checked_at');
        });
    }
};
