<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('property_attribute_values', function (Blueprint $table) {
            $table->id();
            $table->foreignId('property_id')->index();
            $table->foreignId('field_id')->index();
            $table->string('slug')->nullable();
            $table->string('type')->nullable();
            $table->string('value')->nullable()->index();
            $table->float('value_float')->nullable()->index();
            $table->dateTime('value_datetime')->nullable()->index();
            $table->text('value_text')->nullable();
            $table->unsignedInteger('order')->default(0)->index();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('property_attribute_values');
    }
};
