<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('label_rules', function (Blueprint $table) {

            $table->id();
            $table->unsignedBigInteger('label_id')->index();

            $table->string('condition_field', 255)->index();
            $table->text('condition_value')->nullable();
            $table->string('value_data_type', 255)->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('label_rules');
    }
};
