<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('enquiry_types', function (Blueprint $table) {
            $table->string('template_name')->index()->nullable();
        });

        Schema::table('forms', function (Blueprint $table) {
            $table->text('confirmation_message')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('enquiry_types', function (Blueprint $table) {
            $table->dropColumn('template_name');
        });
        Schema::table('forms', function (Blueprint $table) {
            $table->dropColumn('confirmation_message');
        });
    }
};
