<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('car_configurator_models', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('slug')->nullable()->index();
            $table->foreignId('make_id')->index();
            $table->foreignId('model_id')->index();
            $table->boolean('active')->default(0)->index();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });


        Schema::create('car_configurator_sections', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->string('name');
            $table->boolean('active')->default(1)->index();
            $table->boolean('custom')->default(0)->index();
            $table->unsignedInteger('order')->nullable()->index();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_editions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->string('name');
            $table->text('short_description')->nullable();
            $table->decimal('price')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_custom_sections', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->foreignId('section_id')->index();
            $table->string('name');
            $table->text('description')->nullable();
            $table->decimal('price')->nullable();
            $table->string('hex')->nullable();
            $table->string('hex_gradient')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_trims', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->string('name');
            $table->text('short_description')->nullable();
            $table->text('description')->nullable();
            $table->decimal('price')->nullable();
            $table->decimal('monthly_price')->nullable();
            $table->text('data')->nullable();
            $table->foreignId('fuel_type_id')->nullable()->index();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_engines', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->string('name');
            $table->decimal('price')->nullable();
            $table->text('short_description')->nullable();
            $table->foreignId('fuel_type_id')->nullable()->index();
            $table->foreignId('drivetrain_id')->nullable()->index();
            $table->foreignId('transmission_id')->nullable()->index();
            $table->string('fuel_consumption_combined')->nullable();
            $table->string('bhp')->nullable();
            $table->string('max_ev_power')->nullable();
            $table->string('max_engine_power')->nullable();
            $table->string('torque')->nullable();
            $table->string('zero_to_sixty')->nullable();
            $table->string('fuel_capacity')->nullable();
            $table->string('ev_range')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_colours', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->string('name');
            $table->string('description')->nullable();
            $table->string('category')->nullable();
            $table->decimal('price')->nullable();
            $table->string('hex')->nullable();
            $table->string('hex_gradient')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_wheels', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->string('name');
            $table->string('description')->nullable();
            $table->string('category')->nullable();
            $table->decimal('price')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_interiors', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->string('name');
            $table->string('description')->nullable();
            $table->string('category')->nullable();
            $table->string('hex')->nullable();
            $table->string('hex_gradient')->nullable();
            $table->decimal('price')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_model_packages', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->foreignId('package_id')->index();
            $table->decimal('price')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_model_extras', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->foreignId('extra_id')->index();
            $table->decimal('price')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_packages', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->string('category')->nullable();
            $table->decimal('price')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_extras', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->string('category')->nullable();
            $table->decimal('price')->nullable();
            $table->text('data')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });

        Schema::create('car_configurator_restrictions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('model_id')->index();
            $table->morphs('functionality', 'configurator_restriction_functionality');
            $table->morphs('restriction', 'configurator_restriction_restriction');
            $table->string('condition', 20)->nullable();
            $table->timestamps();
            $table->softDeletes();
        });


        Schema::create('customer_car_configurations', function (Blueprint $table) {
            $table->id();
            $table->string('uuid')->index();
            $table->string('name')->nullable();
            $table->string('email')->nullable()->index();
            $table->string('phone_number')->nullable();
            $table->foreignId('customer_id')->nullable()->index();
            $table->foreignId('enquiry_id')->nullable()->index();
            $table->foreignId('model_id')->index();
            $table->unsignedInteger('views')->default(0);
            $table->timestamps();
            $table->softDeletes();
        });
        Schema::create('customer_car_configuration_sections', function (Blueprint $table) {
            $table->id();
            $table->foreignId('configuration_id')->index();
            $table->foreignId('section_id')->index();
            $table->text('details')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('car_configurator_models');
        Schema::dropIfExists('car_configurator_editions');
        Schema::dropIfExists('car_configurator_sections');
        Schema::dropIfExists('car_configurator_custom_sections');
        Schema::dropIfExists('car_configurator_trims');
        Schema::dropIfExists('car_configurator_engines');
        Schema::dropIfExists('car_configurator_colours');
        Schema::dropIfExists('car_configurator_wheels');
        Schema::dropIfExists('car_configurator_interiors');
        Schema::dropIfExists('car_configurator_packages');
        Schema::dropIfExists('car_configurator_extras');
        Schema::dropIfExists('car_configurator_model_packages');
        Schema::dropIfExists('car_configurator_model_extras');
        Schema::dropIfExists('car_configurator_restrictions');
        Schema::dropIfExists('customer_car_configurations');
        Schema::dropIfExists('customer_car_configuration_sections');
    }
};
