<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;

class Seo404 extends Model
{
    protected $table = 'seo_404s';

    /**
     * Mass assign
     *
     * @var string[]
     */
    protected $fillable = [
        'path',
        'hits',
    ];

    protected $casts = [
        'created_at' => 'datetime:d/m/Y H:i',
        'updated_at' => 'datetime:d/m/Y H:i',
    ];

    public static function track(string $url)
    {
        $entry = self::query()->firstOrNew(['path' => $url]);
        $entry->hits++;
        $entry->save();
    }
}
