<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class ApiUsageSnapshot extends Model
{
    use CentralConnection;

    protected $table = 'api_usage_snapshots';

    protected $fillable = [
        'api_usage_id',
        'input',
        'request_time',
    ];

    protected $casts = [
        'input' => 'array'
    ];

    public function usageEntry(): BelongsTo
    {
        return $this->belongsTo(ApiUsage::class);
    }
}
