<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('api_users', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->boolean('is_active')->default(0)->index();
            $table->string('client_id')->nullable();
            $table->string('client_secret')->nullable();
            $table->string('token_type')->default('oauth');
            $table->dateTime('credentials_last_updated_at')->nullable();
            $table->dateTime('credentials_due_for_update_at')->nullable()->index();
            $table->text('notes')->nullable();
            $table->index(['client_id', 'client_secret']);
            $table->timestamps();
        });

        Schema::create('api_user_tenants', function (Blueprint $table) {
            $table->id();
            $table->foreignId('api_user_id')->index();
            $table->string('tenant_id')->index();
        });

        Schema::create('api_tokens', function (Blueprint $table) {
            $table->id();
            $table->foreignId('api_user_id')->index();
            $table->string('token_type')->index();
            $table->string('token')->index();
            $table->string('expires_at')->index();
            $table->timestamps();
        });

        Schema::table('api_usage', function (Blueprint $table) {
            $table->foreignId('api_token_id')->after('tenant_id')->nullable();
            $table->foreignId('api_user_id')->after('tenant_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('api_users');
        Schema::dropIfExists('api_user_tenants');
        Schema::dropIfExists('api_tokens');

        Schema::table('api_usage', function (Blueprint $table) {
            $table->dropColumn([
                'api_user_id',
                'api_token_id',
            ]);
        });
    }
};
