<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('vehicle_offer_content_history', function (Blueprint $table) {
            $table->id();
            $table->string('uuid')->index();
            $table->foreignId('offer_id')->index();
            $table->foreignId('author_id')->nullable()->index();
            $table->boolean('is_active')->index();
            $table->mediumText('data')->nullable();
            $table->mediumText('content')->nullable();
            $table->timestamps();
            $table->softDeletes()->index();
            $table->index('created_at');
            $table->index('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('vehicle_offer_content_history');
    }
};
