<?php

namespace Mtc\MercuryDataModels;

use Mtc\ContentManager\Contracts\Media as MediaModel;
use Mtc\MercuryDataModels\Contracts\SearchableModel;
use Mtc\MercuryDataModels\Tools\UiUrlGenerator;
use OwenIt\Auditing\Contracts\Auditable;

class Media extends MediaModel implements SearchableModel, Auditable
{
    use \OwenIt\Auditing\Auditable;

    public function __construct(array $attributes = [])
    {
        $this->mergeFillable([
            'auto_trader_id'
        ]);
        parent::__construct($attributes);
    }

    /**
     * Search name text
     *
     * @return string
     */
    public function getSearchNameAttribute(): string
    {
        return $this->title;
    }

    /**
     * Search excerpt text
     *
     * @return string
     */
    public function getSearchExcerptAttribute(): string
    {
        return strip_tags($this->description);
    }

    /**
     * Search result icon
     *
     * @return string
     */
    public function getSearchIcon(): string
    {
        return $this->square_thumb_url;
    }

    /**
     * Route to viewing a vehicle as a part of search response
     *
     * @return string
     */
    public function getSearchResultRoute(): string
    {
        return UiUrlGenerator::make('manage-content/media/edit/' . $this->id, [], false);
    }
}
