<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Database\Eloquent\SoftDeletes;
use Mtc\ContentManager\Traits\HasMedia;
use Mtc\MercuryDataModels\Factories\CarConfiguratorWheelFactory;

class CarConfiguratorWheel extends Model
{
    use HasFactory;
    use HasMedia;
    use SoftDeletes;

    protected $table = 'car_configurator_wheels';

    protected $fillable = [
        'model_id',
        'name',
        'description',
        'short_description',
        'category',
        'price',
        'data',
        'order',
    ];

    protected $casts = [
        'data' => 'array',
    ];

    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    protected static function newFactory()
    {
        return CarConfiguratorWheelFactory::new();
    }

    public function restrictions(): MorphMany
    {
        return $this->morphMany(CarConfiguratorRestriction::class, 'functionality');
    }
}
