<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\CarConfiguratorWheel;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\Mtc\MercuryDataModels\ColourMap>
 */
class CarConfiguratorWheelFactory extends Factory
{
    protected $model = CarConfiguratorWheel::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => $this->faker->word,
            'category' => $this->faker->word(),
            'description' => $this->faker->paragraph(),
            'price' => random_int(1, 10000),
            'model_id' => random_int(1, 1000),
        ];
    }
}
