<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('vehicle_makes', function (Blueprint $table) {
            $table->string('cap_id')->index()->nullable();
            $table->string('lcv_cap_id')->index()->nullable();
        });
        Schema::table('vehicle_models', function (Blueprint $table) {
            $table->string('lcv_cap_id')->index()->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('vehicle_makes', function (Blueprint $table) {
            $table->dropColumn('cap_id');
            $table->dropColumn('lcv_cap_id');
        });
        Schema::table('vehicle_models', function (Blueprint $table) {
            $table->dropColumn('lcv_cap_id');
        });
    }
};
