<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Mtc\ContentManager\Traits\HasMedia;

class VehicleTrim extends Model
{
    use HasMedia;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'vehicle_trims';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'name',
        'make_id',
        'model_id',
        'fuel_types',
        'colours',
        'description',
        'transmission_types',
        'mpg',
        'emissions',
        'engine_size',
        'battery_size',
        'range_miles',
        'battery_charge_time',
        'battery_quick_charge_time',
        'bhp',
        'active',
        'zero_to_sixty',
        'doors',
        'seats',
        'wheelbase',
        'cap_id',
        'full_price',
    ];

    protected $casts = [
        'fuel_types' => 'array',
        'colours' => 'array',
        'transmission_types' => 'array',
    ];

    /**
     * Relationship with model
     *
     * @return BelongsTo
     */
    public function make(): BelongsTo
    {
        return $this->belongsTo(VehicleMake::class, 'make_id');
    }

    public function model(): BelongsTo
    {
        return $this->belongsTo(VehicleModel::class, 'model_id');
    }
}
