<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('menu_entries', function (Blueprint $table) {
            $table->boolean('external')->nullable();
            $table->string('css_class')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('menu_entries', function (Blueprint $table) {
            $table->dropColumn([
                'external',
                'css_class',
            ]);
        });
    }
};
