<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('service_location_availability', function (Blueprint $table) {
            $table->unsignedSmallInteger('min_days_in_future_for_booking')->default(0)->nullable();
            $table->unsignedSmallInteger('max_days_in_future_for_booking')->default(90)->nullable();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('service_location_availability', function (Blueprint $table) {
            $table->dropColumn([
                'min_days_in_future_for_booking',
                'max_days_in_future_for_booking',
            ]);
        });
    }
};
