<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\Factories\ColourMapFactory;

class ColourMap extends Model
{
    use HasFactory;

    protected $table = 'colour_mapping';

    protected $fillable = [
        'colour_id',
        'sub_colour',
    ];

    protected static function newFactory()
    {
        return ColourMapFactory::new();
    }

    public function vehicles(): HasMany
    {
        return $this->hasMany(Vehicle::class, 'colour', 'sub_colour');
    }

    public function colour(): BelongsTo
    {
        return $this->belongsTo(Colour::class);
    }
}
