<?php

namespace Mtc\MercuryDataModels\Factories;

use App\Tier;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\Tenant;

class TenantFactory extends Factory
{
    protected $model = Tenant::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'name' => $this->faker->sentence(),
            'tier' => collect(Tier::cases())->random(),
            'suspended_at' => random_int(0,3) ? null : Carbon::now(),
            'suspended_by' => random_int(1, 10),
            'suspended_message' => $this->faker->sentence(),
            'last_invoice_created_at' => Carbon::now()->subDays(random_int(0, 50)),
            'next_invoice_due_at' => Carbon::now()->addDays(random_int(0, 30)),
            'currency' => 'GBP',
        ];
    }
}
