<?php

namespace Mtc\MercuryDataModels\Filters;

class SeatMaxFilter extends SeatMinFilter
{
    public function applyFilter($query, array $selection = [])
    {
        $query->where('seats', '<=', $selection);
    }

    /**
     * Check if $selection (url slug) matches pattern on this filter
     *
     * @param string $selection
     * @return bool
     */
    public function patternMatched(string $selection): bool
    {
        return preg_match('/up-to-[0-9]+-seats/', $selection);
    }

    /**
     * Decode $selection url slug to selection value(s)
     *
     * @param string $selection
     * @return string|array
     */
    public function matchSelections(string $selection)
    {
        preg_match('/up-to-([0-9]+)-seats/', $selection, $matches);
        return $matches[1];
    }

    /**
     * Create URL slug for $selection value
     *
     * @param $selection
     * @return string
     */
    public function createSlug($selection): string
    {
        return 'up-to-' . $selection . '-seats';
    }

    /**
     * Text format of the selection name
     *
     * @param $selection
     * @return string
     */
    public function getSelectionName($selection): string
    {
        return $selection === 1
            ? 'Up To ' . $selection . ' Seat'
            : 'Up To ' . $selection . ' Seats';
    }

    protected function isRangeMaximum(): bool
    {
        return true;
    }

    public function filterType(): string
    {
        return 'seats_max';
    }
}
