<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\MorphOne;
use Mtc\Crm\Traits\ModelSortAndFilter;
use Mtc\Filter\FilterIndex;
use Mtc\MercuryDataModels\Factories\FuelTypeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\OrderByName;

class FuelType extends Model
{
    use HasFactory;
    use OrderByName;
    use ModelSortAndFilter;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'fuel_types';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'id',
        'name',
        'ev_data',
        'mpg_data',
        'autotrader_id',
    ];

    /**
     * Columns shown in JSON response by default
     *
     * @var string[]
     */
    protected $visible = [
        'id',
        'name',
        'ev_data',
        'mpg_data',
    ];

    protected $with = [
        'filterIndex'
    ];

    /**
     * Model factory
     *
     * @return FuelTypeFactory
     */
    protected static function newFactory()
    {
        return FuelTypeFactory::new();
    }

    public function filterIndex(): MorphOne
    {
        return $this->morphOne(FilterIndex::class, 'filter');
    }

    protected function getSlugAttribute(): string
    {
        return $this->filterIndex?->slug ?? '';
    }
}
