<?php

namespace Mtc\MercuryDataModels;


use Mtc\ContentManager\Models\MediaUse as MediaUseModel;

class MediaUse extends MediaUseModel
{
    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'media_id',
        'owner_type',
        'owner_id',
        'alt_text',
        'title',
        'description',
        'caption',
        'dimensions',
        'allowed_sizes',
        'data',
        'order',
        'primary',
        'secondary',
        'flags',
        'interior',
        'exterior',
        'damages',
    ];


    public function getOwnerType(): string
    {
        return match($this->owner_type) {
            'new-car-content', 'new-car-version', 'offer-content', 'offer-version' => 'content',
            default => $this->owner_type,
        };
    }

    protected function cacheName(string $dimensions, string $ownerType): string
    {
        return tenant('id') . '-' . parent::cacheName($dimensions, $ownerType);
    }
}
