<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Mtc\MercuryDataModels\Factories\PropertyCategoryFieldFactory;
use Mtc\MercuryDataModels\Factories\TransmissionTypeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\EnsuresSlug;

class PropertyCategoryField extends Model
{
    use HasFactory;
    use EnsuresSlug;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'property_category_fields';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'category_id',
        'name',
        'slug',
        'type',
        'active',
        'order',
        'data',
        'validation',
        'choices',
    ];

    protected $casts = [
        'active' => 'boolean',
        'data' => 'array',
        'choices' => 'array',
    ];

    protected static function boot()
    {
        parent::boot();
        self::creating(fn(self $field) => $field->ensureSlug());
        self::deleted(fn(self $field) => $field->values()->delete());
    }

    protected static function newFactory()
    {
        return PropertyCategoryFieldFactory::new();
    }

    public function category(): BelongsTo
    {
        return  $this->belongsTo(PropertyCategory::class, 'category_id');
    }


    public function values(): HasMany
    {
        return  $this->hasMany(PropertyAttributeValue::class, 'field_id');
    }

    public function scopeActive(Builder $query): void
    {
        $query->where('active', 1);
    }
}
