<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Factories\SeoRedirectFactory;

class SeoRedirect extends Model
{
    use HasFactory;

    protected $table = 'seo_redirects';

    /**
     * Mass assign
     *
     * @var string[]
     */
    protected $fillable = [
        'from',
        'to',
        'code',
    ];

    /**
     * Hide from JSON
     *
     * @var string[]
     */
    protected $hidden = [
        'created_at',
        'updated_at',
    ];

    /**
     * New model factory
     *
     * @return SeoRedirectFactory
     */
    protected static function newFactory()
    {
        return SeoRedirectFactory::new();
    }
}
