<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Relations\MorphOne;
use Mtc\Crm\Traits\ModelSortAndFilter;
use Mtc\Filter\FilterIndex;
use Mtc\MercuryDataModels\Factories\TransmissionTypeFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Traits\OrderByName;

class TransmissionType extends Model
{
    use HasFactory;
    use OrderByName;
    use ModelSortAndFilter;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'transmissions';

    /**
     * Mass assign columns
     *
     * @var string[]
     */
    protected $fillable = [
        'id',
        'name',
        'autotrader_id',
    ];

    /**
     * Columns shown in JSON response by default
     *
     * @var string[]
     */
    protected $visible = [
        'id',
        'name',
    ];

    protected $with = [
        'filterIndex'
    ];

    /**
     * Model factory
     *
     * @return TransmissionTypeFactory
     */
    protected static function newFactory()
    {
        return TransmissionTypeFactory::new();
    }

    public function filterIndex(): MorphOne
    {
        return $this->morphOne(FilterIndex::class, 'filter');
    }

    protected function getSlugAttribute(): string
    {
        return $this->filterIndex?->slug ?? '';
    }
}
