<?php

namespace Mtc\MercuryDataModels;

use Mtc\MercuryDataModels\Factories\VehicleFinanceFactory;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class VehicleFinance extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'vehicle_finance';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'vehicle_id',
        'provider',
        'finance_type',
        'term',
        'number_of_payments',
        'monthly_price',
        'first_payment',
        'final_payment',
        'total_deposit',
        'apr',
        'interest_rate',
        'total_credit_amount',
        'apply_url',
        'annual_mileage',
        'cash_price',
        'dealer_deposit',
        'customer_deposit',
        'payable_amount',
        'option_to_purchase_fee',
        'documentation_fee',
    ];

    /**
     * Model factory
     *
     * @return VehicleFinanceFactory
     */
    protected static function newFactory()
    {
        return VehicleFinanceFactory::new();
    }

    /**
     * Relationship with Vehicle
     *
     * @return BelongsTo
     */
    public function vehicle(): BelongsTo
    {
        return $this->belongsTo(Vehicle::class, 'vehicle_id');
    }
}
