<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Mtc\MercuryDataModels\Factories\VehicleValuationFactory;

class VehicleValuation extends \Mtc\VehicleValuation\Models\VehicleValuation
{
    use HasFactory;

    protected static function newFactory()
    {
        return VehicleValuationFactory::new();
    }

    public function enquiry(): HasOne
    {
        return $this->hasOne(Enquiry::class, 'valuation_id');
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
