<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateTenantBillablesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('tenant_billables', function (Blueprint $table) {
            $table->id();
            $table->string('tenant_id')->index();
            $table->foreignId('billable_id')->index();
            $table->decimal('price');
            $table->decimal('discounted_price')->nullable();
            $table->integer('quantity')->default(1);
            $table->text('notes')->nullable();
            $table->dateTime('billed_from')->nullable()->index();
            $table->dateTime('billed_until')->nullable()->index();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('tenant_billings');
    }
}
