<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('dealership_opening_times', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('dealership_id')->nullable()->index();
            $table->string('name')->nullable();
            $table->boolean('is_primary')->default(false)->index();
            $table->string('phone_number', 50)->nullable();
            $table->text('open_times')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('dealership_opening_times');
    }
};
