<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Database\Eloquent\Relations\Relation;
use Mtc\MercuryDataModels\Conversion;
use Mtc\MercuryDataModels\Dealership;

class ConversionFactory extends Factory
{
    protected $model = Conversion::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'owner_type' => array_rand(array_keys(Relation::morphMap())),
            'owner_id' => random_int(1, 100),
            'type' => $this->faker->word(),
            'date' => $this->faker->date(),
            'hits' => random_int(1, 100),
        ];
    }
}
