<?php

namespace Mtc\MercuryDataModels\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Mtc\MercuryDataModels\ValuationAdjustment;

class ValuationAdjustmentFactory extends Factory
{
    protected $model = ValuationAdjustment::class;

    /**
     * Define the model's default state.
     *
     * @return array
     */
    public function definition()
    {
        return [
            'is_active' => $this->faker->boolean(),
            'is_increase' => $this->faker->boolean(),
            'adjustment_amount' => random_int(0, 100),
            'adjustment_type' => $this->faker->boolean() ? 'percent' : 'amount',
        ];
    }
}
