<?php

namespace Mtc\MercuryDataModels\Filters;

use App\Facades\Settings;
use App\Filter\FilterIndex;
use Illuminate\Support\Collection;
use Mtc\MercuryDataModels\Colour;
use Mtc\MercuryDataModels\VehicleOffer;

class OfferColourFilter extends ColourFilter
{
    /**
     * Apply selections to current filtered object
     *
     * @param Builder $query
     * @param array $selection
     * @return void
     */
    public function applyFilter($query, array $selection = [])
    {
        $colourNameQuery = FilterIndex::select('name')
            ->where('filter_type', '=', 'colour')
            ->whereIn('slug', $selection);

        $query->when(
            Settings::get('filter-use-colour-mapping'),
            fn ($query) => $query->whereHas('colourMap.colour', fn ($colourQuery) =>
            $colourQuery->whereIn('colour', $colourNameQuery)),
            fn ($query) => $query->whereIn('colour', $selection),
        );
    }

    /**
     * Get available results of this filter type
     *
     *
     * @param \Closure $product_filtering
     * @param int $limit
     * @param array $selections
     * @return Collection
     */
    public function getResults(\Closure $product_filtering, int $limit, array $selections = []): Collection
    {
        if (Settings::get('filter-use-colour-mapping')) {
            return Colour::query()
                ->whereHas('mappedColours.offers', fn($query) => $query
                    ->when(Settings::get('filter-apply-selections-to-results'), fn($query) => $query->where($product_filtering))
                    ->where(fn ($query) => $product_filtering($query)))
                ->distinct()
                ->get();
        }

        return VehicleOffer::query()
            ->when(Settings::get('filter-apply-selections-to-results'), fn($query) => $query->where($product_filtering))
            ->select('colour')
            ->distinct()
            ->get();
    }

    /**
     * Specify model that drives this filter option.
     * Used to build up filter index.
     *
     * @return string
     */
    public function getModel(): string
    {
        $settings = app()->has('site-settings');
        if ($settings && Settings::get('filter-use-colour-mapping')) {
            return Colour::class;
        }
        return VehicleOffer::class;
    }
}
