<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Support\Facades\Config;
use Mtc\ContentManager\Contracts\Content;
use Mtc\MercuryDataModels\Contracts\ContentModel;
use Mtc\MercuryDataModels\Factories\NewCarContentFactory;

class NewCarContent extends Content implements ContentModel
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'new_car_content';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'global_content_id',
        'element_id',
        'car_id',
        'parent_id',
        'template_element_id',
        'slug',
        'name',
        'content',
        'search_content',
        'data',
        'order',
        'hidden',
    ];

    /**
     * Model factory
     *
     * @return NewCarContentFactory
     */
    protected static function newFactory()
    {
        return NewCarContentFactory::new();
    }

    /**
     * Relationship with vehicle
     *
     * @return BelongsTo
     */
    public function car(): BelongsTo
    {
        return $this->belongsTo(NewCar::class, 'car_id');
    }

    /**
     * Relationship with content elements that are nested under this element
     *
     * @return HasMany
     */
    public function subContent(): HasMany
    {
        return $this->hasMany(static::class, 'parent_id');
    }

    /**
     * Relationship with content element that defines structure of this element
     *
     * @return BelongsTo
     */
    public function contentElement(): BelongsTo
    {
        return $this->belongsTo(Config::get('pages.element_model'), 'element_id');
    }

    /**
     * Relationship with global content element (if global element added instead of normal one)
     *
     * @return BelongsTo
     */
    public function globalContent(): BelongsTo
    {
        return $this->belongsTo(Config::get('pages.global_content_model'), 'global_content_id');
    }
}
