<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Builder;
use Stancl\Tenancy\Database\Concerns\CentralConnection;

class Role extends \Spatie\Permission\Models\Role
{
    use CentralConnection;

    protected $visible = [
        'id',
        'name',
        'description',
        'icon',
    ];

    public function scopeNotMtc(Builder $query)
    {
        $query->where('name', '!=', 'mtc');
    }
}
