<?php

namespace Mtc\MercuryDataModels;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Mtc\MercuryDataModels\Factories\SalesChannelHistoryFactory;

class SalesChannelHistory extends Model
{
    use HasFactory;

    /**
     * Table name
     *
     * @var string
     */
    protected $table = 'sales_channel_history';

    /**
     * Mass assign attributes
     *
     * @var string[]
     */
    protected $fillable = [
        'channel',
        'was_successful',
        'vehicle_id',
        'details',
    ];

    /**
     * Cast attributes to types
     *
     * @var string[]
     */
    protected $casts = [
        'was_successful' => 'boolean',
        'created_at' => 'datetime:d/m/Y H:i'
    ];

    /**
     * Track an export flow
     *
     * @param string $channel
     * @param null|int $vehicle_id
     * @param bool $was_successful
     * @param string $details
     * @return void
     */
    public static function store(
        string $channel,
        bool $was_successful,
        string $details = '',
        ?int $vehicle_id = null
    ): Model {
        return self::query()->create([
            'channel' => $channel,
            'vehicle_id' => $vehicle_id,
            'was_successful' => $was_successful,
            'details' => $details,
        ]);
    }

    /**
     * Model factory
     *
     * @return SalesChannelHistoryFactory
     */
    protected static function newFactory()
    {
        return SalesChannelHistoryFactory::new();
    }
}
